#!/bin/sh

# Dit is een simpel PHP-scriptje met het doel de omroep24.nl streams op een Samsung TV tevoorschijn te toveren
# Voorwaarden:
#      installeer de NetPlayer ap (zie tvwidget.pl)
#      installeer het scriptje omroep24.php
#
# Dit werkt op een 40c8700 Samsung TV samen met de NAS, waarop de 2 scripts worden geinstalleerd. In de NetPlayer app dan de url naar het php-script opgeven.
#
#  In het kort:
#    0. Voor elke omroep24 stream
#    		1.  Conveer de inhoud van .asx-files naar een xml-formaat
#
#    De .asx-files bevatten tijdsleutels, waardoor de betreffende links maar beperkt "houdbaar zijn". Daarom moeten de links steeds opnieuw gegenereerd worden.
# 
#  Geen Copyright of zo....   Opgezet door Evert ten Napel   (netplayer@etn.dds.nl)
#


#
# Lijst met alle kanalen te vinden via  http://omroep.freebse.nl/
#
# De ASX-bestanden moeten elke keer opnieuw worden binnengehaald, om er voor te zorgen dat
# er nog een geldige stream (mms)  wordt aangeboden. Anders kunnen ze verlopen zijn
# 
#




convert_ASX2XML_item() {

#
# Get the ASX file from omroep.nl
#
wget $1

ASXFILE=`basename $1`

#
# Convert ASX file to XML format, playable by the TV-Widget Player
#
awk '
BEGIN {print "<item>";
}
$0 ~ /TITLE/ { title=tolower($0);next}
$0 ~ /Title/ { title=tolower($0);next}
$0 ~ /mms/	{stream=substr($2,6,1000);next}
$0 ~ /MoreInfo/	{moreinfo=$2;next}
		{next;}
END		{ print title;
          print "\<description\>&lt;img src=\"http://www.lyngsat-logo.com/icon/tv/nn/nederland4.gif\" alt=\"tn.cz\" Nederland 4 \</description\>";
          print  "\<enclosure url="stream" type=\"video/mpeg\" /\>";
		  print "<guid></guid>"
      print "\<icon url=\"http://www.lyngsat-logo.com/icon/tv/nn/nederland4.gif\" /\>";
	  print "\<pubDate\>\</pubDate\>";
	  print "\</item\>";

}
		
		
' ${ASXFILE} 

rm -rf ${ASXFILE}

}

#
# Get ASX files for all the streams
#
echo "<?xml version=\"1.0\" encoding=\"utf-8\" ?>
<rss version=\"2.0\">
  <channel>
    <title>Omroep 24</title>
    <link>nederland24.nl</link>
    <description>Alle Omroep 24 TV zenders via Internet</description>
    <language>nl</language>
    <copyright>Deze website inclusief de gepubliceerde informatie valt onder het auteurs- en 
	databankenrecht van de NOS. Verveelvoudiging en/of openbaarmaking, anders dan 
	voor eigen niet-commercieel gebruik overeenkomstig onze gebruiksvoorwaarden, 
	zijn zonder de voorafgaande schriftelijke toestemming van de NOS niet toegestaan (C NOS, 2004).</copyright>
" > omroep24.xml



#
# Convert ASX files to XML files, playable by the TV-Widget Player
#
#convert_ASX2XML_item "http://www.nasa.gov/55644main_NASATV_Windows.asx">> omroep24.xml
# NASA-TV
#convert_ASX2XML_item "http://playlist.yahoo.com/makeplaylist.dll?id=1368570" >> omroep24.xml
convert_ASX2XML_item "http://livestreams.omroep.nl/npo/101tv-bb">> omroep24.xml
convert_ASX2XML_item "http://livestreams.omroep.nl/npo/best24-bb">> omroep24.xml
convert_ASX2XML_item "http://livestreams.omroep.nl/npo/consumenten24-bb">> omroep24.xml
convert_ASX2XML_item "http://livestreams.omroep.nl/npo/cultura24-bb">> omroep24.xml
convert_ASX2XML_item "http://livestreams.omroep.nl/npo/familie24-bb">> omroep24.xml
convert_ASX2XML_item "http://livestreams.omroep.nl/npo/geschiedenis24-bb">> omroep24.xml
convert_ASX2XML_item "http://livestreams.omroep.nl/npo/hollanddoc24-bb">> omroep24.xml
convert_ASX2XML_item "http://livestreams.omroep.nl/npo/humortv24-bb">> omroep24.xml
convert_ASX2XML_item "http://livestreams.omroep.nl/nos/journaal24-bb">> omroep24.xml
convert_ASX2XML_item "http://livestreams.omroep.nl/nos/politiek24-bb">> omroep24.xml
convert_ASX2XML_item "http://livestreams.omroep.nl/npo/spirit24-bb">> omroep24.xml
convert_ASX2XML_item "http://livestreams.omroep.nl/npo/sterren24-bb">> omroep24.xml

echo " </channel>
</rss>
" >> omroep24.xml